//
//  MCToolbarBuilder.h
//  MCApplication
//
//  Created by mclark on Sat Jul 28 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

// This class builds a toolbar based on 1 or more config files - one that is past in and contains
// the main config for the toolbar and optional toolbar item configs, and toolbar item configs
// which are collected from various framework and bundle config files  by MCSurveyor 
// (ask the default instance or other instance of MCSurveyor for its toolbarItemConfigs)

#import <AppKit/AppKit.h>


@interface MCToolbarBuilder : NSObject {
    @private
    NSMutableDictionary           *masterToolbarConfigs;
    NSMutableDictionary           *masterToolbarItemRegistries;
    NSMutableDictionary           *defaultToolbarItemRegistry;
    NSMutableDictionary           *allowedToolbarItemRegistry;
	NSMutableDictionary			  *globalToolbarItemRegistry;
    
}

+ (MCToolbarBuilder *)defaultInstance;

// Create a toolbar - various methods which build and return a NSToolbar
- (void)buildToolbars;
- (void)buildMasterToolbarItems;

    // Uses the main config passed in which includes the main toolbar config
    // and possibly toolbar item configs 
    // The returned toolbar does not have it's delegate set.  It is up to the developer to set it on it's return
- (NSToolbar *)copyOfToolbarForIdentifier: (NSString *)identifier;

// Accessors
- (NSMutableDictionary *)toolbarItemRegistryForIdentifier: (NSString *)identifier;
- (NSMutableArray *)defaultToolbarItemIdentifiersForToolbarIdentifier: (NSString *) identifier;
- (NSMutableArray *)allowedToolbarItemIdentifiersForToolbarIdentifier: (NSString *) identifier;
- (NSToolbarDisplayMode)toolbarDisplayModeFromString: (NSString *)display_mode_str;
- (NSDictionary *)masterToolbarItemRegistries;
- (NSDictionary *)defaultToolbarItemRegistry;
- (NSDictionary *)allowedToolbarItemRegistry;

- (NSDictionary *)globalToolbarItemRegistry;
@end

// This is the object passed into the builder for the toolbar delegate.  This object must double 
// as a toolbar delegate and a MCToolbarBuilderDelegate
/* Not needed anymore
@interface NSObject (MCToolbarBuilderDelegate)

- (void)setToolbarBuilder: (MCToolbarBuilder *)toolbar_builder; 
    // allows the delegate to callback to the builder to get at the master toolbar items
- (void)addDefaultToolbarItemIdentifier: (NSString *)identifier;
- (void)removeDefaultToolbarItemIdentifier: (NSString *)identifier;
- (void)addAllowedToolbarItemIdentifier: (NSString *)identifier;
- (void)removeAllowedToolbarItemIdentifier: (NSString *)identifier;

@end
*/

